/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.formatter.nodes;

import com.aptana.formatter.FormatterUtils;
import com.aptana.formatter.IFormatterContext;
import com.aptana.formatter.IFormatterDocument;
import com.aptana.formatter.IFormatterWriter;
import com.aptana.formatter.nodes.FormatterBlockNode;
import com.aptana.formatter.nodes.IFormatterNode;
import com.aptana.formatter.nodes.IFormatterTextNode;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FormatterBlockWithBeginEndNode
extends FormatterBlockNode {
    protected List<IFormatterNode> begin = null;
    protected IFormatterTextNode end;

    public FormatterBlockWithBeginEndNode(IFormatterDocument document) {
        super(document);
    }

    @Override
    public void accept(IFormatterContext context, IFormatterWriter visitor) throws Exception {
        boolean endWithNewLine;
        int blankLines;
        if (this.shouldConsumePreviousWhiteSpaces() && this.getSpacesCountBefore() > 0) {
            this.writeSpaces(visitor, context, this.getSpacesCountBefore());
        }
        if ((blankLines = context.getBlankLines()) > 0) {
            visitor.ensureLineStarted(context);
        }
        context.setBlankLines(this.getBlankLinesBefore(context));
        boolean beginWithNewLine = this.isAddingBeginNewLine();
        if (beginWithNewLine && !visitor.endsWithNewLine() && !this.shouldConsumePreviousWhiteSpaces()) {
            visitor.writeLineBreak(context);
        }
        if (this.begin != null) {
            for (IFormatterNode element : this.begin) {
                element.accept(context, visitor);
            }
        }
        context.resetBlankLines();
        boolean indenting = this.isIndenting();
        if (indenting) {
            context.incIndent();
        }
        boolean childConsumesPreviousWhiteSpace = false;
        if (!this.getBody().isEmpty()) {
            childConsumesPreviousWhiteSpace = this.getBody().get(0).shouldConsumePreviousWhiteSpaces();
        }
        if (!childConsumesPreviousWhiteSpace && beginWithNewLine) {
            visitor.writeLineBreak(context);
        }
        super.accept(context, visitor);
        if (indenting) {
            context.decIndent();
        }
        if ((endWithNewLine = this.isAddingEndNewLine()) && !visitor.endsWithNewLine()) {
            visitor.writeLineBreak(context);
        }
        if (this.end != null) {
            visitor.write(context, this.end.getStartOffset(), this.end.getEndOffset());
        }
        if (this.getSpacesCountAfter() > 0) {
            this.writeSpaces(visitor, context, this.getSpacesCountAfter());
        }
        context.setBlankLines(this.getBlankLinesAfter(context));
    }

    protected int getBlankLinesBefore(IFormatterContext context) {
        return -1;
    }

    protected int getBlankLinesAfter(IFormatterContext context) {
        return -1;
    }

    public IFormatterNode[] getBegin() {
        return FormatterUtils.toTextNodeArray(this.begin);
    }

    public void setBegin(IFormatterTextNode begin) {
        if (this.begin == null) {
            this.begin = new ArrayList<IFormatterNode>();
        }
        this.begin.add(begin);
    }

    public void insertBefore(List<IFormatterNode> nodes) {
        if (this.begin == null) {
            this.begin = new ArrayList<IFormatterNode>();
        }
        this.begin.addAll(0, nodes);
    }

    public IFormatterTextNode getEnd() {
        return this.end;
    }

    public void setEnd(IFormatterTextNode node) {
        this.end = node;
    }

    @Override
    public int getStartOffset() {
        if (this.begin != null) {
            return ((IFormatterTextNode)this.begin.get(0)).getStartOffset();
        }
        return super.getStartOffset();
    }

    @Override
    public int getEndOffset() {
        if (this.end != null) {
            return this.end.getEndOffset();
        }
        if (!super.isEmpty()) {
            return super.getEndOffset();
        }
        if (this.begin != null) {
            return ((IFormatterTextNode)this.begin.get(this.begin.size() - 1)).getEndOffset();
        }
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return this.begin == null && this.end == null && super.isEmpty();
    }

    @Override
    public List<IFormatterNode> getChildren() {
        if (this.begin == null && this.end == null) {
            return super.getChildren();
        }
        ArrayList<IFormatterNode> result = new ArrayList<IFormatterNode>();
        if (this.begin != null) {
            result.addAll(this.begin);
        }
        result.addAll(super.getChildren());
        if (this.end != null) {
            result.add(this.end);
        }
        return result;
    }

    @Override
    public String toString() {
        return this.begin + "\n" + super.toString() + "\n" + this.end;
    }
}

